/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.MantarayConfig;
import com.tristankechlo.livingthings.entity.SharkEntity;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.entity.misc.IScaleableMob;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class MantarayEntity
extends AbstractSchoolingFish
implements IMobVariants,
IScaleableMob,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> MANTARAY_VARIANT = SynchedEntityData.m_135353_(MantarayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> MANTARAY_SCALING = SynchedEntityData.m_135353_(MantarayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public MantarayEntity(EntityType<? extends MantarayEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public static AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, MantarayConfig.health()).m_22268_(Attributes.f_22279_, MantarayConfig.movementSpeed());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.55));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, SharkEntity.class, 16.0f, 1.3, 1.45));
        this.f_21345_.m_25352_(3, (Goal)new FollowFlockLeaderGoal((AbstractSchoolingFish)this));
        this.f_21345_.m_25352_(4, (Goal)new SwimGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MANTARAY_VARIANT, (Object)0);
        this.f_19804_.m_135372_(MANTARAY_SCALING, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("MantarayVariant", this.getVariant());
        compound.m_128344_("MantarayScaling", this.getScaling());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128445_("MantarayVariant"));
        this.setScaling(compound.m_128445_("MantarayScaling"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        int colorBlueVariant = (Integer)MantarayConfig.get().colorBlueVariant.get();
        int colorBrownVariant = (Integer)MantarayConfig.get().colorBrownVariant.get();
        byte variant = this.getRandomVariant(this.f_19796_, new byte[]{0, 1}, new int[]{colorBlueVariant, colorBrownVariant});
        this.setVariant(variant);
        this.setScaling(MantarayEntity.getWeightedRandomScaling(this.f_19796_));
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static byte getWeightedRandomScaling(RandomSource random) {
        int scaling1Weight = (Integer)MantarayConfig.get().scalingSmallVariant.get();
        int scaling2Weight = (Integer)MantarayConfig.get().scalingNormalWeight.get();
        int scaling3Weight = (Integer)MantarayConfig.get().scalingLargeVariant.get();
        int scaling4Weight = (Integer)MantarayConfig.get().scalingExtraLargeWeight.get();
        if (scaling1Weight <= 0 && scaling2Weight <= 0 && scaling3Weight <= 0 && scaling4Weight <= 0) {
            return 0;
        }
        Optional scaling = WeightedRandom.m_216822_((RandomSource)random, (List)ImmutableList.of((Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling1Weight), -2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling2Weight), 0), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling3Weight), 2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling4Weight), 6)));
        return ((IScaleableMob.WeightedMobScaling)scaling.get()).scaling;
    }

    public static boolean checkMantaraySpawnRules(EntityType<MantarayEntity> entity, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_6425_(pos).m_205070_(LivingThingsTags.MANTARAY_SPAWNABLE_ON) && world.m_6425_(pos.m_7494_()).m_205070_(LivingThingsTags.MANTARAY_SPAWNABLE_ON);
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_8077_();
    }

    public int m_5792_() {
        return MantarayConfig.maxSpawnedInChunk();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    @Override
    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(MANTARAY_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(MANTARAY_VARIANT, (Object)variant);
    }

    @Override
    public byte getScaling() {
        return (Byte)this.f_19804_.m_135370_(MANTARAY_SCALING);
    }

    @Override
    public void setScaling(byte scaling) {
        this.f_19804_.m_135381_(MANTARAY_SCALING, (Object)scaling);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)Items.f_42446_);
    }

    protected SoundEvent m_5699_() {
        return ModSounds.MANTARAY_FLOP.get();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.MANTARAY;
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final MantarayEntity fish;

        public SwimGoal(MantarayEntity fish) {
            super((PathfinderMob)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean m_8036_() {
            return this.fish.m_6004_() && super.m_8036_();
        }
    }
}

